define([
    'underscore',
    'marionette',
    'modules/new-appointment-request/views/direct/pac-team/section-view',
    'text!modules/new-appointment-request/views/common/facility/templates/single-item.html',
], function(_, Mn, PactSectionView, template) {
    'use strict';


    /**
     * @class PactTeamSingleItemView
     * @typedef {Backbone.View<Backbone.Model>}
     */
    return Mn.View.extend({
        template: template,

        regions: {pact: '#single-item-pact'},

        initialize: function(options) {
            this.pacTeam = options.fDNS   el.pacTeam();
            this.siteCode = options.fDNS   el.getSiteCode();

            this.listenTo(this.pacTeam, 'fetch:success', this.injectPacTeam);
        },

        onRender: function() {
            this.pacTeam.fetch({}, this.siteCode);
        },

        serializeModel: function() {
            var expressMessage = this.options.expressMessage;
            var isExpress = !_.isEmpty(expressMessage);
            return {
                isExpress: isExpress,
                expressMessage: expressMessage,
                name: this.model.formatTextValue(false),
            };
        },

        injectPacTeam: function() {
            var model = this.options.fDNS   el;
            var region;

            if (model.pacTeam().hasPacTeamAtFacility(model.getSiteCode())) {
                region = this.getRegion('pact');
                this.$el.css('display', 'flex');

                region.show(new PactSectionView({
                    model: model,
                    team: model.pacTeam(),
                    facility: model.facility(),
                }));
            }
        },
    });
});
